/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.index.core;

import com.aptana.core.util.StringUtil;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QueryResult {
    private String word;
    private HashSet<String> documentNames;
    private List<Map<String, Object>> documentTables;

    public QueryResult(String word) {
        this(word, null);
    }

    public QueryResult(String word, Map<String, Object> table) {
        this.word = word;
        this.documentNames = new HashSet();
        this.documentTables = new ArrayList<Map<String, Object>>();
        if (table != null) {
            this.documentTables.add(table);
        }
    }

    public void addDocumentName(String path) {
        this.documentNames.add(path);
    }

    public String getWord() {
        return this.word;
    }

    public Set<String> getDocuments() {
        return Collections.unmodifiableSet(this.documentNames);
    }

    public boolean isEmpty() {
        return this.documentTables.isEmpty() && this.documentNames.isEmpty();
    }

    public void addDocumentTable(Map<String, Object> wordsToDocNumbers) {
        this.documentTables.add(wordsToDocNumbers);
    }

    public String toString() {
        return MessageFormat.format("[word: ''{0}'', documents: {1}]", this.getWord(), StringUtil.join((String)", ", this.getDocuments()));
    }
}

